//
//
// HTTP Ping, ping websites without ICMP packets
//
// NOTE: This file is windows-only.
//		 in order to use it in linux, you must use the linux time functions
//
// This file is in public domain.
// (PD) 2004 Charles Lohr

#include "ezsockets.h"
#include <iostream>
#include <time.h>

using namespace std;

int main ( int argv, char ** argc ) 
{
	if ( argv < 2 )
	{
		cout<<"ERROR: No hostname inputted."<<endl;
		cout<<"Usage: HTTPPing [hostname]"<<endl;
		cout<<"    Output:"<<endl;
		cout<<"       [Total Time]:[Ping time]"<<endl;
		return -1;
	}

	ezSockets conn;
	conn.Create();

	char buf[512];
	const char * Host = argc[1];
	char request[2048];
	request[0]='\0';
	strcat( request, "GET / HTTP/1.1\r\nHost: " );
	strcat( request, Host );
	strcat( request, "\r\nConnection: closed\r\n\r\n" );

	while(1)
	{
		conn.Close();
		conn.Create();
		int Start = clock();
		if ( !conn.Connect( Host, 80) )
		{
			cout<<clock()<<":ERROR"<<endl;
			continue;
		}
		int Connect = clock();
		conn.SendData( request, strlen(request) );

		conn.ReadData( buf, 512 );

		int Transfer = clock();

		cout<<clock()<<":"<<Transfer-Start<<endl;
	}
	return 0;
}